﻿using System;
using System.Linq;
using Verse;

namespace RBB_Code {

	public class PlaceWorker_BasicBridge : PlaceWorker {
		public override AcceptanceReport AllowsPlacing(BuildableDef checkingDef, IntVec3 loc, Rot4 rot, Thing thingToIgnore = null) {
			TerrainDef terrainDef = base.Map.terrainGrid.TerrainAt(loc);
			if (terrainDef == TerrainDef.Named("WaterShallow") || terrainDef == TerrainDef.Named("WaterOceanShallow") || terrainDef == TerrainDef.Named("WaterMovingShallow") || terrainDef == TerrainDef.Named("Marsh")) {
				return true;
			}
			return new AcceptanceReport("RBB.BasicBridge".Translate());
		}
	}

	public class PlaceWorker_DeepWaterBridge : PlaceWorker {
		public override AcceptanceReport AllowsPlacing(BuildableDef checkingDef, IntVec3 loc, Rot4 rot, Thing thingToIgnore = null) {
			TerrainDef terrainDef = base.Map.terrainGrid.TerrainAt(loc);
			if (terrainDef == TerrainDef.Named("WaterDeep") || terrainDef == TerrainDef.Named("WaterOceanDeep") || terrainDef == TerrainDef.Named("WaterMovingDeep")) {
				return true;
			}
			return new AcceptanceReport("RBB.DeepWaterBridge".Translate());
		}
	}

	public class PlaceWorker_Boardwalk : PlaceWorker {
		public override AcceptanceReport AllowsPlacing(BuildableDef checkingDef, IntVec3 loc, Rot4 rot, Thing thingToIgnore = null) {
			string waterNear = "no";
			for (int i = -1; i < 2; i++) {
				for (int j = -1; j < 2; j++) {
					int x = loc.x + i;
					int z = loc.z + j;
					IntVec3 newSpot = new IntVec3(x, 0, z);
					string terrainCheck = base.Map.terrainGrid.TerrainAt(newSpot).defName;
					if (terrainCheck.Contains("Water") || terrainCheck.Equals("Marsh") || terrainCheck.Equals("BridgeMarsh")) {
						waterNear = "yes";
						break;
					}
				}
			}
			if (waterNear == "yes") {
				return true;
			}
			return new AcceptanceReport("RBB.Boardwalk".Translate());
		}
	}

	public class Building_Bridge : Building {
		public string TerrainTypeAtBaseCellDefAsString;
		public override void Destroy(DestroyMode mode = 0) {
			base.Map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named(this.TerrainTypeAtBaseCellDefAsString));
			base.Destroy(mode);
		}
		public override void ExposeData() {
			base.ExposeData();
			Scribe_Values.Look<string>(ref this.TerrainTypeAtBaseCellDefAsString, "TerrainTypeAtBaseCellDefAsString", null, false);
		}
		public override void SpawnSetup(Map map, bool flag) {
			base.SpawnSetup(map, flag);
			TerrainDef terrainDef = map.terrainGrid.TerrainAt(base.Position);
			if ((object)terrainDef == (object)TerrainDef.Named("WaterShallow")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeWaterShallow"));
			}
			if ((object)terrainDef == (object)TerrainDef.Named("WaterOceanShallow")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeWaterOceanShallow"));
			}
			if ((object)terrainDef == (object)TerrainDef.Named("WaterMovingShallow")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeWaterMovingShallow"));
			}
			if ((object)terrainDef == (object)TerrainDef.Named("WaterDeep")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeWaterDeep"));
			}
			if ((object)terrainDef == (object)TerrainDef.Named("WaterOceanDeep")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeWaterOceanDeep"));
			}
			if ((object)terrainDef == (object)TerrainDef.Named("WaterMovingDeep")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeWaterMovingDeep"));
			}
			if ((object)terrainDef == (object)TerrainDef.Named("Marsh")) {
				this.TerrainTypeAtBaseCellDefAsString = terrainDef.ToString();
				map.terrainGrid.SetTerrain(base.Position, TerrainDef.Named("BridgeMarsh"));
			}
		}
	}
	
}
